//
//  FSRootFileListViewController.m
//  Downloader
//
//  Created by hxhg-LiDong on 13-2-2.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import "FSRootFileListViewController.h"
#import "UIViewController+Extended.h"
#import "FSFileItem.h"

@interface FSRootFileListViewController ()

@end

@implementation FSRootFileListViewController

static __weak FSRootFileListViewController *_sharedController = nil;

+ (FSRootFileListViewController *)sharedController {
    return _sharedController;
}

- (id)init {
    if (self = [super initWithPath:FSDocumentsDirectory]) {
        _sharedController = self;
        
        UINavigationItem *navigationItem = [self navigationItem];
        UIBarButtonItem *cancelItem = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemCancel target:self action:@selector(onHome)];
        
        [navigationItem setLeftBarButtonItem:cancelItem];
        
        [_fileItem loadAttributesIfNeeded];
        
        _rootDirectoryMonitor = [[FSDirectoryMonitor alloc] initWithPath:FSDocumentsDirectory];
        [_rootDirectoryMonitor startMonitoringWithDelegate:self];
    }
    return self;
}

- (void)dealloc {
    if (self == _sharedController) {
        _sharedController = nil;
    }
    
    [_rootDirectoryMonitor stopMonitoring];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    if (_downloadsFileListController) {
        _downloadsFileListController = nil;
    }
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [super tableView:tableView didSelectRowAtIndexPath:indexPath];
    
    if (_nextFileListViewController) {
        if ([FSDownloadsDirectory isEqualToString:[[_nextFileListViewController fileItem] path]]) {
            _downloadsFileListController = _nextFileListViewController;
        }
    }
}

- (void)directoryDidChangeItems:(NSSet *)items {
    if (_selectedIndexPath) {
        NSArray *subitems = [_fileItem subitems];
        const NSInteger row = [_selectedIndexPath row];
        
        if (row < [subitems count]) {
            FSFileItem *selectedFileItem = [subitems objectAtIndex:row];
            
            if ([items containsObject:[selectedFileItem fileName]]) {
                UINavigationController *navigationController = [self navigationController];
                
                if ([selectedFileItem isDirectory]) {
                    BOOL isDirectory = NO;
                    
                    if (![theFileManager fileExistsAtPath:[selectedFileItem path] isDirectory:&isDirectory] || !isDirectory) {
                        [navigationController popToRootViewControllerAnimated:YES];
                    }
                } else {
                    [navigationController dismissPresentedViewControllerRecursively];
                }
            }
        }
    }
}

- (void)directoryDidFinishChanging {
    [self refresh];
}

- (void)beginUpdate {
    [super beginUpdate];
    [_rootDirectoryMonitor stopMonitoring];
}

- (void)endUpdate {
    [super endUpdate];
    [_rootDirectoryMonitor startMonitoringWithDelegate:self];
}

- (void)reloadDonwloadsDirectory {
    if (_downloadsFileListController) {
        [_downloadsFileListController refresh];
    } else {
        NSArray *subitems = [_fileItem subitems];
        
        for (FSFileItem *subitem in subitems) {
            if ([FSDownloadsDirectory isEqualToString:[subitem path]]) {
                [subitem clearSubitems];
                break;
            }
        }
    }
    [_tableView reloadData];
}

- (void)onHome {
    [[self navigationController] dismissViewControllerAnimated:YES completion:NULL];
}

- (void)onSettings {
}

@end
